* Title: 	table6.do
* Version: 	23 May 2018
* Purpose: 	Create table for income sources for prime-age men


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/tables/log/table6, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip RegionI PrimeMaleD FamilyI ///
	EmploymentI Inc_* wtsupp ///
	using dta/asec_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep data for 2010 to 2016
keep if year>=2010 & year<=2016

* Exclude cases with negative total income
drop if (Inc_FamilyTotal < 0 | Inc_PersonalTotal < 0)

*******************************************************************************
* (2) Create table of income sources
*******************************************************************************

* Group 1: employed, all
gen group1 = (EmploymentI == 0)

* Group 2: employed, low-income
gen group2 = (EmploymentI == 0 & Inc_FamilyTotal < 40000)

* Group 3: short-term jobless, living alone
gen group3 = (EmploymentI == 1 & FamilyI == 0)

* Group 4: short-term jobless, living with others 
gen group4 = (EmploymentI == 1 & FamilyI != 0)

* Group 5: long-term jobless, living alone
gen group5 = (EmploymentI == 2 & FamilyI == 0)

* Group 6: long-term jobless, living with others
gen group6 = (EmploymentI == 2 & FamilyI != 0)

egen test = rowtotal(group1 group3 group4 group5 group6)
assert test==1
drop test

forval i = 1/6 {
	foreach var of varlist Inc_FamilyTotal-Inc_Other {
		assert !mi(`var')
		gen `var'`i' = `var' if (group`i' == 1)
	}
	
	gen Total`i' = PrimeMaleD if (group`i' == 1)
}

collapse 	(sum)	Total = PrimeMaleD Total* ///
			(mean)	Inc_*1 Inc_*2 Inc_*3 Inc_*4 Inc_*5 Inc_*6 ///
			[pw = wtsupp]
			
forval i = 1/6 {
	gen Group`i'l_GovernmentOther = Inc_GovernmentTotal`i' - Inc_Unemp`i' ///
									- Inc_Disability`i' - Inc_Vet`i'			  
	gen Group`i'm_Other_Inc_Round = Inc_PersonalTotal`i' - Inc_Wage`i' ///
									- Inc_Investment`i' - Inc_Retirement`i' ///
									- Inc_WorkersComp`i' - Inc_FamilyTransfer`i' ///
									- Inc_GovernmentTotal`i'
	gen Group`i'n_Share = Total`i'/Total

					
	ren Inc_FamilyTotal`i' 		Group`i'a_FamilyTotal
	ren Inc_PersonalTotal`i'	Group`i'b_PersonalTotal
	ren Inc_Wage`i'				Group`i'c_Wage
	ren Inc_Investment`i'		Group`i'd_Investment
	ren Inc_Retirement`i'		Group`i'e_Retirement
	ren Inc_WorkersComp`i'		Group`i'f_WorkersComp
	ren Inc_FamilyTransfer`i'	Group`i'g_FamilyTransfer
	ren Inc_GovernmentTotal`i'	Group`i'h_GovernmentTotal
	ren Inc_Unemp`i'			Group`i'i_Unemp
	ren Inc_Disability`i'		Group`i'j_Disability
	ren Inc_Vet`i'				Group`i'k_Vet
	
	drop Total`i' Inc_GovernmentOther`i' Inc_Other`i'
}
reshape long Group1 Group2 Group3 Group4 Group5 Group6, i(Total) j(category) str
drop Total

replace category = "Total family income" 		if category == "a_FamilyTotal"
replace category = "Total individual income" 	if category == "b_PersonalTotal"
replace category = "Wage" 						if category == "c_Wage"
replace category = "Investment/Business" 		if category == "d_Investment"
replace category = "Retirement" 				if category == "e_Retirement"
replace category = "Workers' compensation" 		if category == "f_WorkersComp"
replace category = "Family transfers" 			if category == "g_FamilyTransfer"
replace category = "Total government support" 	if category == "h_GovernmentTotal"
replace category = "Unemployment" 				if category == "i_Unemp"
replace category = "Disability" 				if category == "j_Disability"
replace category = "Veterans benefits" 			if category == "k_Vet"
replace category = "Other government support"	if category == "l_GovernmentOther"
replace category = "Other sources" 				if category == "m_Other_Inc_Round"
replace category = "Share of prime-age men" 	if category == "n_Share"

ren Group1 Employed_All
ren Group2 Employed_LowIncome
ren Group3 STJobless_LiveAlone
ren Group4 STJobless_LiveOthers
ren Group5 LTJobless_LiveAlone
ren Group6 LTJobless_LiveOthers


* Save dataset
save output/tables/dta/table6.dta, replace


*******************************************************************************
* (3) End of file
*******************************************************************************

log close
exit, clear
